/* Compile options:  -ml (Large code model) */
#include <p18f4553.h>
#include <stdio.h>
#include <usart.h>

// Setup configuration bits
        #pragma config PLLDIV   = 5         // (20 MHz crystal on PICDEM FS USB board)
        #pragma config CPUDIV   = OSC1_PLL2   
        #pragma config USBDIV   = 2         // Clock source from 96MHz PLL/2
        #pragma config FOSC     = HSPLL_HS
        #pragma config FCMEN    = OFF
        #pragma config IESO     = OFF
        #pragma config PWRT     = OFF
        #pragma config BOR      = ON
        #pragma config BORV     = 3
        #pragma config VREGEN   = ON      //USB Voltage Regulator
        #pragma config WDT      = OFF
        #pragma config WDTPS    = 32768
        #pragma config MCLRE    = ON
        #pragma config LPT1OSC  = OFF
        #pragma config PBADEN   = OFF
//      #pragma config CCP2MX   = ON
        #pragma config STVREN   = ON
        #pragma config LVP      = OFF
//      #pragma config ICPRT    = OFF       // Dedicated In-Circuit Debug/Programming
        #pragma config XINST    = OFF       // Extended Instruction Set
        #pragma config CP0      = OFF
        #pragma config CP1      = OFF
//      #pragma config CP2      = OFF
//      #pragma config CP3      = OFF
        #pragma config CPB      = OFF
//      #pragma config CPD      = OFF
        #pragma config WRT0     = OFF
        #pragma config WRT1     = OFF
//      #pragma config WRT2     = OFF
//      #pragma config WRT3     = OFF
        #pragma config WRTB     = OFF       // Boot Block Write Protection
        #pragma config WRTC     = OFF
//      #pragma config WRTD     = OFF
        #pragma config EBTR0    = OFF
        #pragma config EBTR1    = OFF
//      #pragma config EBTR2    = OFF
//      #pragma config EBTR3    = OFF
        #pragma config EBTRB    = OFF

void rx_handler (void);


/*
 * Step #1  The data is allocated into its own section.
 */

#pragma code rx_interrupt = 0x8
void rx_int (void)
{
  _asm goto rx_handler _endasm
}
#pragma code

#pragma interrupt rx_handler
void rx_handler (void)
{
  unsigned char c;

  /* Get the character received from the USART */
  c = ReadUSART();
  if (c >= '0' && c <= '9')
    {
      c -= '0';
      /* Display value received on LEDs */
      PORTB = c;

      /*
       * Step #2  This example did not need an additional
       * pointer to access the large memory because of the
       * multi-dimension array.
       *
       * Display the string located at the array offset
       * of the character received
       */
    
	 if (c==0) putrsUSART ((const far rom char *)"String #0\n\r");
	 if (c==1) putrsUSART ((const far rom char *)"String #1\n\r");
	 if (c==2) putrsUSART ((const far rom char *)"String #2\n\r");
	 if (c==3) putrsUSART ((const far rom char *)"String #3\n\r");
	 if (c==4) putrsUSART ((const far rom char *)"String #4\n\r");
	 if (c==5) putrsUSART ((const far rom char *)"String #5\n\r");
	 if (c==6) putrsUSART ((const far rom char *)"String #6\n\r");
	 if (c==7) putrsUSART ((const far rom char *)"String #7\n\r");
	 if (c==8) putrsUSART ((const far rom char *)"String #8\n\r");
	 if (c==9) putrsUSART ((const far rom char *)"String #9\n\r");

	


    }
  else
    {
      /*
       * Step #2  This example did not need an additional
       * pointer to access the large memory because of the
       * multi-dimension array.
       *
       * Invalid character received from USART.
       * Display error string.
       */
      	putrsUSART ((const far rom char *)"Invalid key (0-9 only)\n\r");

      /* Display value received on LEDs */
      PORTB = c;
    }

    /* Clear the interrupt flag */
    PIR1bits.RCIF = 0;
}

void main (void)
{
  /* Configure all PORTB pins for output */
  TRISB = 0;

  /*
   * Open the USART configured as
   * 8N1, 9600 baud, in polled mode
   */
  OpenUSART (USART_TX_INT_OFF &
             USART_RX_INT_ON &
             USART_ASYNCH_MODE &
             USART_EIGHT_BIT &
             USART_CONT_RX &
             USART_BRGH_LOW, 77);

  /* Display a prompt to the USART */
  putrsUSART (
    (const far rom char *)"\n\rEnter a digit 0-9!\n\r");

  /* Enable interrupt priority */
  RCONbits.IPEN = 1;

  /* Make receive interrupt high priority */
  IPR1bits.RCIP = 1;

  /* Enable all high priority interrupts */
  INTCONbits.GIEH = 1;

  /* Loop forever */
  while (1)
    ;
}
